#include <bits/stdc++.h>
#define ll long long
#define endl '\n'
#define pii pair<ll,ll>

using namespace std;

struct P
{
    ll X, Y;
    void in() {cin >> X >> Y;}
    P operator - (P A) {return{X - A.X, Y - A.Y};}
    void operator -= (P A) {X -= A.X; Y -= A.Y;}
    ll operator * (P A) {return (X*A.Y - Y*A.X);}
    bool operator < (P A) {return make_pair(X, Y) < make_pair(A.X, A.Y);}
};

vector <P> get_convex(vector <P> poly, ll N)
{
    vector <P> hull;
    for(int j = 0; j < 2; j++)
    {
        ll S = hull.size();
        for(int i = 0; i < N; i++)
        {
            P C = poly[i];
            while((ll) hull.size() >= S + 2)
            {
                P A = hull.end()[-2];
                P B = hull.end()[-1];
                if((B - A) * (C - A) <= 0) break;
                hull.pop_back();
            }
            hull.push_back(C);
        }
        reverse(poly.begin(), poly.end());
        hull.pop_back();
    }
    return hull;
}

ll find_area(vector <P> points)
{
    ll area = 0;
    ll N = (ll) points.size();
    for(int i = 0; i < N; i++) area += points[i]*points[(i + 1)%N];
    return abs(area)/2;
}

bool u_trouglu(P A, P B, P C, P D)
{
    ll cr1 = (B - A)*(D - A);
    ll cr2 = (C - B)*(D - B);
    ll cr3 = (A - C)*(D - C);
    bool p = (cr1 > 0) || (cr2 > 0) || (cr3 > 0);
    bool n = (cr1 < 0) || (cr2 < 0) || (cr3 < 0);
    return !(n && p);
}

int find_idx(vector <P> poly, ll N, P B)
{
    ll L = 0, R = N - 1;
    while(R - L >= 2)
    {
        ll mid = (L + R)/2;
        if(u_trouglu(poly[0], poly[mid], poly[mid + 1], B)) return mid;
        if(u_trouglu(poly[0], poly[mid + 1], poly[mid + 2], B)) return mid + 1;
        L = mid + 1;
    }
    return -1;
}

int main()
{
    ios_base::sync_with_stdio(false); cin.tie(0);
    ll N;
    cin >> N;
    vector <P> poly(N);
    vector <P> where[N];
    map <pii, bool> in_convex;
    map <pii, int> idx;
    for(int i = 0; i < N; i++) poly[i].in();
    sort(poly.begin(), poly.end());
    vector <P> hull = get_convex(poly, N);
    ll beg_area = find_area(hull);
    ll S = (ll) hull.size();
    ll res = beg_area;
    for(int i = 0; i < S; i++) {in_convex[{hull[i].X, hull[i].Y}] = true; idx[{hull[i].X, hull[i].Y}] = i;}
    for(int i = 0; i < N; i++)
    {
        if(in_convex[{poly[i].X, poly[i].Y}]) continue;
        int which_triangle = find_idx(hull, S, poly[i]);
        if(which_triangle == -1) continue;
        if(u_trouglu(hull[which_triangle%S], hull[(which_triangle + 1)%S], hull[(which_triangle + 2)%S], poly[i]))
            where[(which_triangle + 1)%S].push_back(poly[i]);
        if(u_trouglu(hull[(which_triangle - 1 + S)%S], hull[which_triangle%S], hull[(which_triangle + 1)%S], poly[i]))
           where[which_triangle%S].push_back(poly[i]);
        if(u_trouglu(hull[(which_triangle - 2 + S)%S], hull[(which_triangle - 1 + S)%S], hull[which_triangle%S], poly[i]))
            where[(which_triangle - 1 + S)%S].push_back(poly[i]);
    }
    for(int i = 0; i < S; i++)
    {
        ll area_now;
        P uno = hull[i];
        P dos = hull[(i + 1)%S];
        P tres = hull[(i + 2)%S];
        vector <P> trougao; trougao.push_back(uno); trougao.push_back(dos); trougao.push_back(tres);
        if(((ll) where[idx[{dos.X, dos.Y}]].size()) == 0) area_now = find_area(trougao);
        else
        {
            vector <P> points;
            points.push_back(uno);
            for(auto p : where[idx[{dos.X, dos.Y}]]) points.push_back(p);
            points.push_back(tres);
            vector <P> this_hull = get_convex(points, (ll) points.size());
            area_now = find_area(trougao) - find_area(this_hull);
        }
        res = min(res, beg_area - area_now);
    }
    cout << res << endl;
    return 0;
}